%% This subroutine computes the SAM of signal x
% ----------------------------------------------------

% Reference: The spectral amplitude modulation: A nonlinear
% filtering process for diagnosis of rolling element bearings 
% Authors: Moshrefzadeh A, Fasana A, Antoni J
% Journal: Mechanical Systems and Signal Processing

function  SAM(x,Fs,dg,LE,Y,kk) 
 
s(1,:) = x(1:end) - mean(x(1:end));

FT = fft((s));
rFT = abs(FT);
angFT = angle(FT);

j = 1;
for ii = dg
    
    rFT2 = rFT .^ ii;
    Msig = ifft((real(rFT2)) .* exp(1i*angFT)); % Modified Signal
    Msig = real(Msig) - mean(real(Msig));
    adw = abs(hilbert(real(Msig))).^2; % Squared Envelope

% Log-Enveloe
    if LE == 1 
        adw = log2(adw); 
    end
    
% SES
    Len = length(adw);
    [pxx,f] = pwelch(adw,ceil(1*Len),0,ceil(1.0*Len),Fs,'psd'); 

    % f = linspace(f(1),f(end),2*(length(f))-2)';
    Z0(:,j) = pxx;

% Normalization of SES
    zxc = 30;
    Z(:,j) = Z0(:,j)/max(Z0(zxc:end,j));
    j = j + 1;
    
end

% Plot the raw signal
% =======================
t = 0:1/Fs:length(s)/Fs-1/Fs;
figure('units','normalized','outerposition',[0.0 0.5 0.3 0.5])
plot(t,s)
set(gca,'Fontsize',10);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')
xlabel('Time (s)'),xlim([0 max(t)])
ylabel('Acceleration (m/s^2)')
title('Time signal','Fontsize',12)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Plot the Results
%%%%%%%%%%%%%%%%%%%%%%%%
fdf = 5100;
sx = zxc:fdf;
ZZ = Z(sx,:);
LZ = length(ZZ);
%%%%%%%%%%%%%%%%%%%%%%%%
figure('units','normalized','outerposition',[0.3 0 0.7 1]);
%%%%%%%%%%%%%%%%%%%%%%%%
sd = 12; % Number of collected spectral lines
gf = zxc;
sxm2 = gf:1:fdf;

for j = 1: length(dg)
    for i = 1:length(sxm2)
        ZZm2(i,j) = max( Z(gf+(i-1)-floor(sd/2):gf+i+floor(sd/2)-2,j) );
    end
end
hFig = subplot(3,1,1);
surf(dg,f(sx),real(ZZ),'FaceColor','interp'); 
set(gca,'Fontsize',10);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')
colorbar
set(hFig, 'view', [80 45])
xlabel('MO')
xlim([dg(1) dg(end)])
ylim([f(zxc) f(fdf)])
ylabel('Frequency (Hz)')
zlabel('Normalized Amplitude')
colormap(gca,'Parula')
% if LE == 1
%     title('log-SAM','Fontsize',13)
% else
%     title('SAM','Fontsize',13)
% end
set(hFig, 'Xdir', 'reverse')
%%%%%%%%%%%%%%%%%%%%%%%%
subplot(3,1,2);
imagesc(f(sxm2),dg,real(ZZm2'),[0 1.0])
colorbar
colormap(gca,flipud(hot))
axis xy
ylabel('MO')
set(gca,'Fontsize',10);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')
caxis([0.1 1])
%%%%%%%%%%%%%%%%%%%%%%%%
subplot(3,1,3);
plot(f(sx),max(ZZ,[],2),'k','LineWidth',1)
set(gca,'Fontsize',10);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')
xlabel('Frequency (Hz)')
ylabel('Normalized Amplitude')
xlim([f(zxc) f(fdf)])
ylim([0 1.1])
grid on
tmp=get(gca,'position');
set(gca,'position',[tmp(1) tmp(2) 0.93*tmp(3) 1*tmp(4)])
if LE == 1
    title('log-MSES','Fontsize',13)
else
global fr
      [ijk optimum] = min(abs(f-fr));        
      Optimummin=optimum-10;
      Optimummax=optimum+10;
      [ijk optimum] = max(FT(Optimummin:Optimummax)); 
      optimum=optimum+Optimummin-1; 
      fr_newSAM = f(optimum);
      S = max(ZZ,[],2);
      f = f(sx);
      save filename S f fr_newSAM
    title('MSES','Fontsize',13)
end

if Y == 0
    selected(kk,Fs,rFT,angFT,sx,LE,zxc)
end

end

%% selected MO
function selected(kk,Fs,rFT,angFT,sx,LE,zxc)

    rFT2 =  rFT .^ kk;
    Msig2 = ifft((real(rFT2)) .* exp(1i*angFT) ); % Modified Signal
    Msig2 = real(Msig2)-mean(Msig2);
    adw = abs( hilbert( real(Msig2(1:end)) ) ).^2; % Squared Envelope
    if LE ==1
    adw = log2(adw); % Log envelope
    end    

    Len = length(adw);
    [pxx,f] = pwelch(adw,ceil(Len),0,ceil(Len),Fs,'psd');
    Z1 = pxx;
    Z2 = Z1/max(Z1(zxc:end));
    
    figure('units','normalized','outerposition',[0.4 0 0.5 1]);
    subplot(3,1,1)
    plot(0:1/Fs:(length(Msig2)-1)/Fs,real(Msig2))
    set(gca,'Fontsize',10);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')
    xlim([0 1/Fs*length(Msig2)])
    xlabel('Time (s)'); ylabel('Amplitude')
    title(['Modified Signal',' (MO = ',num2str(kk),')'],'Fontsize',13)
    
    subplot(3,1,2)
    len = ceil(length(Msig2));
    FMsig2 = (fft(Msig2));
    plot(0:Fs/len:Fs-(Fs/len),abs(FMsig2),'-','LineWidth',0.5)  
    xlim([0 Fs/2])
    set(gca,'Fontsize',11);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')   
    ylabel('Amplitude')
    title('Magnitude Spectrum','Fontsize',13)
    
    subplot(3,1,3)
    plot(f(sx),Z2(sx),'-','LineWidth',1.0)
    set(gca,'Fontsize',11);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')
    ylim([0 1.1])
    xlim([0 f(sx(end))])
    xlabel('Frequency (Hz)')
    ylabel('Normalized Amplitude')
    if LE == 1
        title('LSES','Fontsize',13)
    else
        title('SES','Fontsize',13)  
    end
    hold on;
end
       


